// Excel3Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "Excel3.h"
#include "Excel3Dlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CExcel3Dlg dialog




CExcel3Dlg::CExcel3Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CExcel3Dlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CExcel3Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	::CoInitializeEx(NULL, 0);
}

BEGIN_MESSAGE_MAP(CExcel3Dlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
    ON_BN_CLICKED(IDC_BUTTON1, &CExcel3Dlg::OnBnClickedButton1)
END_MESSAGE_MAP()


// CExcel3Dlg message handlers

BOOL CExcel3Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CExcel3Dlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CExcel3Dlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CExcel3Dlg::OnBnClickedButton1()
{
    const int iloscRzutow = 10;
    CApplication oExcel;
    COleVariant covOptional(DISP_E_PARAMNOTFOUND,VT_ERROR);
    COleException e;
    
    if(!oExcel.CreateDispatch(L"Excel.Application", &e))
    {
        e.ReportError();
        return;
    }
    else
    {
        CWorkbooks oBooks = oExcel.get_Workbooks();
        CWorkbook oBook = oBooks.Add(covOptional);
        CWorksheets oSheets = oBook.get_Worksheets();
        CWorksheet oSheet = oSheets.get_Item(COleVariant((short)1));
        CRange oRange = oSheet.get_Cells();
        CFont0 font;
        CString tmp, tmp1;
        
        for(int n = 1; n <= iloscRzutow; n++)
        {     
            tmp.Format(L"=A%d+B%d", n, n);
            oRange.put_Item(COleVariant((short)n), COleVariant((short)1), 
                COleVariant((short)(1+rand()%5)));
            oRange.put_Item(COleVariant((short)n), COleVariant((short)2), 
                COleVariant((short)(1+rand()%5)));    
            oRange.put_Item(COleVariant((short)n), COleVariant((short)3), 
                COleVariant(tmp)); //suma oczek
        }    
        
        // sumy
        tmp.Format(L"=sum(A1:A%d)", iloscRzutow);
        oRange.put_Item(COleVariant((short)(iloscRzutow+1)), COleVariant((short)1),
            COleVariant(tmp));
        tmp.Format(L"=sum(B1:B%d)", iloscRzutow);
        oRange.put_Item(COleVariant((short)(iloscRzutow+1)), COleVariant((short)2),
            COleVariant(tmp));
        tmp.Format(L"=sum(C%d:C%d) ", 1,iloscRzutow);
        oRange.put_Item(COleVariant((short)(iloscRzutow+1)), COleVariant((short)3),
            COleVariant(tmp));
        
        // wartoci rednie
        tmp.Format(L"=average(A1:A%d)", iloscRzutow);
        oRange.put_Item(COleVariant((short)(iloscRzutow+2)), COleVariant((short)1),
            COleVariant(tmp));
        tmp.Format(L"=average(B1:B%d)", iloscRzutow);
        oRange.put_Item(COleVariant((short)(iloscRzutow+2)), COleVariant((short)2),
            COleVariant(tmp));
        tmp.Format(L"=average(C1:C%d) ", iloscRzutow);
        oRange.put_Item(COleVariant((short)(iloscRzutow+2)), COleVariant((short)3),
            COleVariant(tmp));     

        // formatowanie sumy       
        tmp.Format(L"A%d", iloscRzutow+1);
        tmp1.Format(L"C%d", iloscRzutow+1);
        
        oRange = oSheet.get_Range(COleVariant(tmp), 
            COleVariant(tmp1));
        font = oRange.get_Font();
        font.put_Bold(COleVariant((short)TRUE));
        
        // formatowanie rednie
        tmp.Format(L"A%d", iloscRzutow+2);
        tmp1.Format(L"C%d", iloscRzutow+2);
        
        oRange = oSheet.get_Range(COleVariant(tmp), 
            COleVariant(tmp1));
        font = oRange.get_Font();
        font.put_Italic(COleVariant((short)TRUE));
    }
    
    oExcel.put_Visible(TRUE);
    oExcel.put_UserControl(TRUE);

    oExcel.ReleaseDispatch();
}
